<?php
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */


    class VisualizzatoreApprovazioneFile extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $datiApprovazione = parent::getDb()->leggiSingolaRiga("geec_approvazioniFile",$dati["idElemento"]);
            $queryDocumenti   = "SELECT * FROM geecD_documenti WHERE cartella={$datiApprovazione["cartellaDaApprovare"]}";
            $risDocumenti     = parent::getDb()->eseguiQueryLettura($queryDocumenti);

            if(isset($_GET["status"]) && $_GET["status"]==200) {
                echo"<div class=\"col-12\">
                       <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                           Le tue preferenze sono sate inviate
                           <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                 <span aria-hidden=\"true\">&times;</span>
                           </button>
                       </div>
                   </div>";
            }
            
            if(strtotime($datiApprovazione["termineApprovazione"])<strtotime(date("Y-m-d"))) {
                ?>
                <div class="col-12 alert alert-warning">
                    <?= $datiApprovazione["testoTermineScaduto"] ?>
                </div>
                <?php
            }
            
            ?>

            <div class="form-row multisteps-form__form approva-file row-cols-1 row-cols-sm-2 row-cols-lg-3">
                <?php
                    while($documento = $risDocumenti->fetch_assoc()) {
                        $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$documento["id"]} ORDER BY id DESC LIMIT 1";
                        $risUltimaVersione   = parent::getDb()->eseguiQueryLettura($queryUltimaVersione);
                        $datiUltimaVersione  = $risUltimaVersione->fetch_assoc();
                        
                        $datiFile   = pathinfo($datiUltimaVersione["percorsoFile"]);
                        
                        switch($datiFile["extension"]) {
                            case 'mp4':
                                ?>
                                    <div class="col mb-3">
                                        <div class="custom-control custom-checkbox mb-3 thumb bg-light p-3">
                                            <input type="checkbox" class="custom-control-input" name="<?= $documento["nome"] ?>" id="approvazioneDocumento<?= $documento["id"] ?>">
                                            <label class="custom-control-label w-100" for="approvazioneDocumento<?= $documento["id"] ?>">
                                                <h6 class="text-break"><?= $documento["nome"] ?></h6>
                                                <small class="mb-2 d-block"><?= $documento["descrizione"] ?></small>
                                                <video class="full-width" controls>
                                                  <source src="<?= $ultimaVersione["percorsoFile"] ?>" type="video/mp4">
                                                   Il tuo browser non supporta l'lemento audio.
                                                </video>
                                            </label>
                                        </div>
                                    </div>
                                <?php
                                break;
                            case 'mp3':
                                ?>
                                    <div class="col mb-3">
                                        <div class="custom-control custom-checkbox mb-3 thumb bg-light p-3">
                                            <input type="checkbox" class="custom-control-input" name="<?= $documento["nome"] ?>" id="approvazioneDocumento<?= $documento["id"] ?>">
                                            <label class="custom-control-label w-100" for="approvazioneDocumento<?= $documento["id"] ?>">
                                                <h6 class="text-break"><?= $documento["nome"] ?></h6>
                                                <small class="mb-2 d-block"><?= $documento["descrizione"] ?></small>
                                                <audio class="full-width" controls>
                                                  <source src="<?= $ultimaVersione["percorsoFile"] ?>" type="audio/mpeg">
                                                   Il tuo browser non supporta l'lemento audio.
                                                </audio>
                                            </label>
                                        </div>
                                    </div>
                                <?php
                                break;
                            case 'jpg':
                                $this->stampaApprovazioneImmagine($documento,$datiUltimaVersione);
                                break;
                            case 'jpeg':
                                $this->stampaApprovazioneImmagine($documento,$datiUltimaVersione);
                                break;
                            case 'png':
                                $this->stampaApprovazioneImmagine($documento,$datiUltimaVersione);
                                break;
                            case 'gif':
                                $this->stampaApprovazioneImmagine($documento,$datiUltimaVersione);
                                break;
                            default:
                                $this->stampaApprovazioneDocumentoGenerico($documento,$datiFile["extension"],$datiUltimaVersione);
                        }
                    }
                ?>
            </div>
            <?php 
                if(strtotime($datiApprovazione["termineApprovazione"])>=strtotime(date("Y-m-d"))) {
                    ?>
                    <hr>
                    <div class="text-right">
                        <a class="btn btn-primary" data-toggle="modal" data-target="#modalInviaApprovazione">Approva selezionati<i class="far fa-check-circle ml-2"></i></a>
                    </div>
                    <?php
                }
            ?>
            <!-- modal invia approvazione -->
            <div class="modal fade" id="modalInviaApprovazione" tabindex="-1" role="dialog" aria-labelledby="aggiungi un componente" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Invia approvazione</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="titolo-del-sito">Email</label>
                                        <input type="text" class="form-control" id="emailApprovazione" value="" placeholder="Inserisci la tua email">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" data-dismiss="modal" onclick="approvaElementiSelezionati(<?= $datiApprovazione["id"] ?>)"><i class="fas fa-check mr-2"></i>Invia approvazione</button>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        
        function stampaApprovazioneImmagine($documento,$datiUltimaVersione) {
            ?>
                <div class="col mb-3">
                    <div class="custom-control custom-checkbox mb-3 thumb bg-light p-3">
                        <input type="checkbox" class="custom-control-input" name="<?= $documento["nome"] ?>" id="approvazioneDocumento<?= $documento["id"] ?>">
                        <label class="custom-control-label w-100" for="approvazioneDocumento<?= $documento["id"] ?>">
                            <h6 class="text-break"><?= $documento["nome"] ?></h6>
                            <small class="mb-2 d-block"><?= $documento["descrizione"] ?></small>
                            <img class="img-fluid w-100" src="<?= $datiUltimaVersione["percorsoFile"] ?>">
                        </label>
                    </div>
                </div>
             <?php
        }

        function stampaApprovazioneDocumentoGenerico($documento,$estensione,$datiUltimaVersione) {
            ?>
                <div class="col mb-3">
                    <div class="custom-control custom-checkbox mb-3 thumb bg-light p-3">
                        <input type="checkbox" class="custom-control-input" name="<?= $documento["nome"] ?>" id="approvazioneDocumento<?= $documento["id"] ?>">
                        <label class="custom-control-label w-100" for="approvazioneDocumento<?= $documento["id"] ?>">
                            <h6><i class="<?= iconaEstensione($estensione) ?> fa-2x mr-2"></i> <a class="text-break" href=<?= $datiUltimaVersione["percorsoFile"] ?> target="_blank"><?= $documento["nome"] ?> <i class="fas fa-arrow-down fa-sm"></i></a></h6>
                            <small class="mb-2 d-block"><?= $documento["descrizione"] ?></small>
                        </label>
                    </div>
                </div>
             <?php
        }
    }